<?php
 require_once('config.php');
 require_once('functions.php');
class MySQLDatabase
{
    private $connection;
    public $last_query;
    private $magic_quotes_active;
    private $real_escape_string_exists;
    public $row;


    function __construct()
    {
        $this->open_connection();
        $this->magic_quotes_active = get_magic_quotes_gpc();
        $this->real_escape_string_exists = function_exists("mysqli_real_escape_string");

    }

    public function open_connection()
    {
        $this->connection = new mysqli(DB_SERVER, DB_USER, DB_PASS);
        if (!$this->connection) {
          // die("Database connection failed: " . mysql_error());
           echo "Connection could not be established.";

        } else {
            $db_select = mysqli_select_db( $this->connection, DB_NAME );
            if (!$db_select) {

              // die("Database selection failed " . mysql_error());
                $this->error("Database selection failed.");
            }else{
                
                 //$this->error("Database selection successful.");
            }

        }
    }

    public function close_connection()
    {
        if (isset($this->connection)) {
            mysql_close($this->connection);
            unset($this->connection);
        }

    }

    public function query($sql)
    {
        $result = mysqli_query($this->connection, $sql );
          $this->last_query = $sql;
        $this->confirm_query($result);
        return $result;

    }

    public function escape_value($value)
    {

        
        if ($this->real_escape_string_exists) {

            if ($this->magic_quotes_active) {
                $value = stripslashes($value);
            }
            $value = mysqli_real_escape_string($this->connection,$value);
        } else {
            if (!$this->magic_quotes_active) {
                $value = addslashes($value);
            }
        }
        return $value;
    }

// Database neutral methods
    public function fetch_array($result_set)
    {

        // if (mysql_fetch_array($result_set)){
            return mysqli_fetch_array($result_set);
           
        //  }else {
        //      $this->error("Could not fetch selected rows from the database.");
        // }
    }

    public function num_rows($result_set)
    {
         //if ($row= mysql_num_rows($result_set)){
            return  mysqli_num_rows($result_set);
        // }else {
        //     $this->error("Row count from database query failed.");
        // }
    }

    public function insert_id()
    {
        // if ($row= mysql_insert_id($this->connection)){
            return mysqli_insert_id($this->connection);
        // }else {
        //     $this-error("Could not insert the last data-id");
        // }
       
    }

    public function affected_rows()
    {
        // if (mysql_affected_rows($this->connection)){

            return  mysqli_affected_rows($this->connection);   
        // }else {
        //      $this->error("No rows was affected");
        //    }
}
    private function confirm_query($result)
    {

        if (!$result) {
          //  $this-error("Operation was not successful. ". mysql_error($this->connection));
             $output = "Database query failed. " . mysqli_error($this->connection) . "<br/><br/>";
             $output = "Last SQL Query: " . $this->last_query;
            $this->error($output);
           //
            //die($output);
        }
    }

   private function error ($error=""){
    if ($error!=""){
        echo('<style="background-color:brown; padding:10px; border-radius:10px; width:100%">'.$error.'</style>');
    }
}

}

$database = new MySQLDatabase();

?>